﻿using UIKit;

namespace AsReaderSDK4MAUIDemo.CustomControls
{
    public class ListCell : ViewCell
    {
        Image typeImage;
        Label pcLabel, epcLabel, countLabel;

        public static readonly BindableProperty TypeProperty = BindableProperty.Create("Type", typeof(string), typeof(ListCell), "Type");
        public static readonly BindableProperty PcProperty = BindableProperty.Create("Pc", typeof(string), typeof(ListCell), "Pc");
        public static readonly BindableProperty EpcProperty = BindableProperty.Create("Epc", typeof(string), typeof(ListCell), "Epc");
        public static readonly BindableProperty CountProperty = BindableProperty.Create("Count", typeof(string), typeof(ListCell), "Count");

        public string Type
        {
            get { return (string)GetValue(TypeProperty); }
            set { SetValue(TypeProperty, value); }
        }

        public string Pc
        {
            get { return (string)GetValue(PcProperty); }
            set { SetValue(PcProperty, value); }
        }

        public string Epc
        {
            get { return (string)GetValue(EpcProperty); }
            set { SetValue(EpcProperty, value); }
        }

        public string Count
        {
            get { return (string)GetValue(CountProperty); }
            set { SetValue(CountProperty, value); }
        }

        [Obsolete]
        public ListCell()
        {
            typeImage = new Image { Aspect = Aspect.AspectFit, WidthRequest = 25, HeightRequest = 25, HorizontalOptions = LayoutOptions.Start };
            pcLabel = new Label { TextColor = Colors.Black, FontSize = 14, HorizontalOptions = LayoutOptions.Start };
            epcLabel = new Label { TextColor = Colors.Black, FontSize = 14,
                LineBreakMode = LineBreakMode.TailTruncation,
                WidthRequest = 270,
                HorizontalOptions = LayoutOptions.Start,
            };
            countLabel = new Label { TextColor = Colors.LightGreen, FontSize = 12, HorizontalOptions = LayoutOptions.Start };

            StackLayout typeLayout = new StackLayout
            {
                Padding = new Thickness(10, 0, 0, 0),
                Orientation = StackOrientation.Horizontal,
                HorizontalOptions = LayoutOptions.StartAndExpand,
                Children = { typeImage }
            };

            var viewLayout1 = new StackLayout()
            {
                Orientation = StackOrientation.Horizontal,
                Children = { typeLayout }
            };

            StackLayout pcLayout = new StackLayout
            {
                Padding = new Thickness(20, 0, 0, 0),
                Orientation = StackOrientation.Vertical,
                HorizontalOptions = LayoutOptions.StartAndExpand,
                Children = { pcLabel }
            };

            var viewLayout2 = new StackLayout()
            {
                Orientation = StackOrientation.Horizontal,
                Children = { viewLayout1, pcLayout }
            };

            StackLayout epcLayout = new StackLayout
            {
                Padding = new Thickness(55, -5, 0, 0),
                Orientation = StackOrientation.Vertical,
                HorizontalOptions = LayoutOptions.StartAndExpand,
                Children = { epcLabel }
            };

            var viewLayout3 = new StackLayout()
            {
                Orientation = StackOrientation.Vertical,
                Children = { viewLayout2, epcLayout }
            };

            StackLayout countLayout = new StackLayout
            {
                Padding = new Thickness(0, 10, 10, 0),
                Orientation = StackOrientation.Vertical,
                HorizontalOptions = LayoutOptions.EndAndExpand,
                Children = { countLabel }
            };

            var viewLayout4 = new StackLayout()
            {
                Orientation = StackOrientation.Horizontal,
                Children = { viewLayout3, countLayout }
            };
            View = viewLayout4;
        }

        protected override void OnBindingContextChanged()
        {
            base.OnBindingContextChanged();
            if (BindingContext != null)
            {
                typeImage.Source = Type;
                pcLabel.Text = Pc;
                epcLabel.Text = Epc;
                countLabel.Text = Count;
                string selectType = Preferences.Get("selectType", "0");
                if (selectType == "2" && Epc.Length == 24)
                {
                    string headerStr = Epc.Substring(0, 6);
                    if ("010104" == headerStr)
                    {
                        epcLabel.TextColor = Colors.Red;
                    } else
                    {
                        epcLabel.TextColor = Colors.Black;
                    }
                } else {
                    epcLabel.TextColor = Colors.Black;
                }
            }
        }
    }
}