//
//  AsReaderBarcodeProtocol.h
//  AsReaderDockSDK
//
//  @brief  This file defines a delegate protocol for handling barcode device events in the AsReaderDockSDK. It includes methods for processing barcode data, responding to factory reset commands, and managing various device-specific features.
//
//  Created by mac on 2017/9/7.
//  Copyright © 2017年 ZYL. All rights reserved.
//
#import "AsReader025SBarcode.h"

#ifndef AsReaderBarcodeProtocol_h
#define AsReaderBarcodeProtocol_h


#endif /* AsReaderBarcodeProtocol_h */

@protocol AsreaderBarcodeDeviceDelegate <NSObject>

@required

@optional
// DO NOT USE THIS. deprecated. please use the 'receivedBarcodeData' instead.
- (void)barcodeDataReceived:(NSData *)data __deprecated_msg("use receivedBarcodeData instead.");

/**
 *  @brief      Function that is called when tag data is received (barcode type)
 *  @param      data : Data of barcode tag read
 */
- (void)receivedBarcodeData:(NSData *)data;

/**
 *  @brief      Response to "Barcode Factory Reset"
 *  @details    Function that is called when the reader sends a response code to "Barcode Factory Reset" in Barcode type
 *  @param      status : reset start(0x00), reset complete(0xFF)
 */
- (void)receiveFactoryReset:(int)status;


// DO NOT USE THIS. deprecated. please use the 'receivedBypassPayload' instead.
- (void)ackUserCommandReceived:(NSData *)rawData __deprecated_msg("use receivedBypassPayload instead.");
/**
 *  @brief      bypass data according to user command
 *  @param      rawData : Data
 */
- (void)receivedBypassPayload:(NSData *)rawData;

//M24D
- (void)receivedCodeID:(int)codeID;
- (void)receivedOCR: (BOOL)isNone ocrAon: (BOOL)isOCRAon ocrBOn: (BOOL)isOCRBon;
- (void)receivedHID:(BOOL)hidOn receivediOSHID:(BOOL)iOShidOn;
- (void)receivedPresentationMode:(BOOL)isOn;
- (void)receivedSleepBeep:(NSData *)data;
- (void)receivedBarcodeSetSsiSuccess:(NSData *)data;
- (void)receivedSymbologies:(NSDictionary*)symbols;
- (void)receivedGetAutoLaunch: (BOOL)isOn bundle:(NSString*)data;
- (void)receivedBarcodeSecurity:(NSDictionary*)security;

//025S
/**
 *  @brief    Send the "Start scan" command to the reader(ASR-025S)
 *  @details  Function that is called when a response code to "Start Scan" is received
 *  @param    barcodeData : Barcode data
 *  @param    barcodeType : Barcode type
 */
- (void)receivedScanBarcodeData:(NSData *)barcodeData barcodeType:(AsReader025SBarcodeType)barcodeType;

/**
 *  @brief    Send the "Get sleep buzzer" command to the reader(ASR-025S)
 *  @details  Function that is called when a response code to "Get Sleep Buzzer" is received
 *  @param    sleepBuzzer : Open (0x00) Other : Close
 */
- (void)didGetSleepBuzzerReceived:(int)sleepBuzzer;

/**
 *  @brief    Send the "Set sleep buzzer" command to the reader(ASR-025S)
 *  @details  Function that is called when a response code to "Set Sleep Buzzer" is received
 *  @param    status : Success (0x00) Other : FAILED
 */
- (void)didSetSleepBuzzer:(int)status;

/**
 *  @brief    Send the "Get barcode timeout" command to the reader(ASR-025S)
 *  @details  Function that is called when a response code to "Get Barcode Timeout" is received
 *  @param    barcodeTimeOut : Barcode timeout
 */
- (void)didGetBarcodeTimeOutReceived:(int)barcodeTimeOut;

/**
 *  @brief    Send the "Set barcode timeout" command to the reader(ASR-025S)
 *  @details  Function that is called when a response code to "Set Barcode Timeout" is received
 *  @param    status : Success (0x00) Other : FAILED
 */
- (void)didSetBarcodeTimeOut:(int)status;
@end

