import 'package:flutter/services.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:asreader_sdk4/asreader_sdk4_method_channel.dart';

void main() {
  TestWidgetsFlutterBinding.ensureInitialized();

  MethodChannelAsreaderSdk4 platform = MethodChannelAsreaderSdk4();
  const MethodChannel channel = MethodChannel('asreader_sdk4');

  setUp(() {
    TestDefaultBinaryMessengerBinding.instance.defaultBinaryMessenger.setMockMethodCallHandler(
      channel,
      (MethodCall methodCall) async {
        return '42';
      },
    );
  });

  tearDown(() {
    TestDefaultBinaryMessengerBinding.instance.defaultBinaryMessenger.setMockMethodCallHandler(channel, null);
  });

  test('getPlatformVersion', () async {
    expect(await platform.getPlatformVersion(), '42');
  });
}
